	TITLE	'MDBS CALL INTERFACE TYPE 02 PROGRAM'
;PROGRAM
;		MDBS CALL INTERFACE TYPE 02 PROGRAM
;PROGRAMMER
;		ROBERT M. WHITE
;DATE WRITTEN
;		AUGUST 27, 1980
;(C)COPYRIGHT	1980,H & W COMPUTER SYSTEMS, INC.
;PURPOSE
;		THIS ROUTINE INTERFACES FOR ALL MDBS CALLS THAT
;		LOOK LIKE THE FOLLOWING IN PLI:
;			CALL XXX(PARM1,RTNCODE);
;		WHERE PARM1 GOES INTO THE DE PARAMETER.
;		
;REMARKS
;		THIS MODULE CONTAINS SEVERAL ENTRY POINTS
;		WHICH CORRESPOND THE TO THE MDBS FUNCTION
;		NAME BEING CALLED.

;		DO INITIALIZATION.
	NAME	'MDBS02'
MDBS02:	CSEG

;		ACS - ADD CURRENT OF RUN UNIT TO SET
ACS:	DS	0
	PUBLIC	ACS
	MVI	A,00		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		CCT - CHECK CURRENT OF RUN UNIT TYPE.
CCT:	DS	0
	PUBLIC	CCT
	MVI	A,02		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		CR - CREATE RECORD.
CR:	DS	0
	PUBLIC	CR
	MVI	A,06		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		DRM - DELETE RECORD BASED ON CURRENT MEMBER.
DRM:	DS	0
	PUBLIC	DRM
	MVI	A,09		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		DRO - DELETE RECORD BASED ON CURRENT OWNER.
DRO:	DS	0
	PUBLIC	DRO
	MVI	A,10		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		DRR - DELETE RECORD BASED ON CURRENT RECORD.
DRR:	DS	0
	PUBLIC	DRR
	MVI	A,11		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		RMS - REMOVE CURRENT MEMBER FROM SET
RMS:	DS	0
	PUBLIC	RMS
	MVI	A,42		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		RSM - REMOVE ALL SET MEMBERS.
RSM:	DS	0
	PUBLIC	RSM
	MVI	A,43		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SCM - SET CURRENT OF RUN UNIT BASED ON MEMBER
SCM:	DS	0
	PUBLIC	SCM
	MVI	A,44		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SCO - SET CURRENT OF RUN UNIT BASED ON OWNER
SCO:	DS	0
	PUBLIC	SCO
	MVI	A,45		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SCR - SET CURRENT OF RUN UNIT BASED ON CURRENT RECORD.
SCR:	DS	0
	PUBLIC	SCR
	MVI	A,46		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SMC - SET MEMBER BASED ON CURRENT OF RUN UNIT
SMC:	DS	0
	PUBLIC	SMC
	MVI	A,51		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SOC - SET OWNER BASED ON CURRENT OF RUN UNIT
SOC:	DS	0
	PUBLIC	SOC
	MVI	A,55		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SRM - SET CURRENT RECORD BASED ON MEMBER
SRM:	DS	0
	PUBLIC	SRM
	MVI	A,60		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SRO - SET CURRENT RECORD BASED ON OWNER
SRO:	DS	0
	PUBLIC	SRO
	MVI	A,61		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SAVE THE FUNCTION CODE.
MAIN:
	STA	FUNC

;		MOVE INPUT PARMS INTO OUTPUT PARM LIST.
	MOV	E,M		;GET FIRST PARM.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE IT.
	SHLD	PRM3
	XCHG
	MOV	E,M		;GET SECOND PARM.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE IT.
	SHLD	PRM5

;		CALL THE MDBS CALL INTERFACE.
	LXI	H,PRMLST	;POINT TO PARAMETER LIST.
	JMP	MDBSCL		;GO PERFORM THE FUNCTION.
	EXTRN	MDBSCL
	PAGE
;****************************************************************
;*			PROGRAM CONSTANTS			*
;****************************************************************

;		INPUT PARM.
	DSEG
PRMLST:				;PL/1 PARAMETER LIST
PRM1:	DW	FUNC			;FUNCTION CODE
PRM2:	DW	NULCL8			;BC PARM
PRM3:	DW	0			;DE PARM
PRM4:	DW	NULCL8			;HL PARM
PRM5:	DW	0			;RETURN CODE
PRM6:	DW	NULPTR			;BLOCK PTR
PRM7:	DW	NULB15			;BLOCK LENGTH
FUNC:	DB	0
NULCL8:	DB	'        '
NULPTR:	DW	0
NULB15:	DW	0
	END
